﻿var callbacksSettings = {
    context: $(".v-callBackSettings"),
    selectedDisabledDates: [],
    disabledDatesCalendar: null,
    unavailableWeekdays: [],
    initialize: function () {
        if ($(".v-callbacksCalendar", callbacksSettings.context).length > 0) {
            var from = $("#Calendar_From", callbacksSettings.context);
            var to = $("#Calendar_To", callbacksSettings.context);
            callbacksSettings.disabledDatesCalendar = $(".h-disabledDatesCalendar", callbacksSettings.context);

            from.datepicker({
                maxDate: to.val(),
                onClose: function () {
                    var minDate = $(this).val();

                    to.datepicker("option", "minDate", minDate);

                    callbacksSettings.disabledDatesCalendar.datepicker("option", "minDate", minDate);
                }
            });

            to.datepicker({
                minDate: from.val(),
                onClose: function () {
                    var maxDate = $(this).val();

                    from.datepicker("option", "maxDate", maxDate);

                    callbacksSettings.disabledDatesCalendar.datepicker("option", "maxDate", maxDate);
                }
            });

            callbacksSettings.context.on("click", ".datepicker-calendar .calendarIcon", function () {
                var parent = $(this).closest(".datepicker-calendar");
                $(".calendar-input", parent).datepicker("show");
            });
            
            var disabledDatesValue = $("#Calendar_DisabledDatesJSON", callbacksSettings.context).val();
            var disabledDates = (disabledDatesValue.length > 0) ? disabledDatesValue.split(",") : "";

            callbacksSettings.disabledDatesCalendar.multiDatesPicker({
                addDates: disabledDates,
                separator: ",",
                minDate: from.val(),
                maxDate: to.val(),
                defaultDate: "",
                onSelect: function () {
                    var dates = callbacksSettings.disabledDatesCalendar.multiDatesPicker("getDates");
                    callbacksSettings.updateDisabledDates(dates);
                }
            });

            callbacksSettings.updateCalendarWeekdaysState();
        }

        a4.initializeInputs(callbacksSettings.context);
    },
    bindEvents: function () {
        callbacksSettings.context.on("click", ".h-copyCallBackSettings", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("GetCallBacks", "Settings"), { projectId: fieldOptions.projectId, sourceProjectId: sourceProjectId },
                function (result) {
                    $(".v-callBacksContent", callbacksSettings.context).html(result);
                    callbacksSettings.initialize();
                    $("form.validate-save").a4unsavedChanges("change");
                });
            }, resources.CallbackTitle);
        });

        callbacksSettings.context.on("click", ".v-calendar-days input[type=checkbox]", function () {
            callbacksSettings.updateCalendarWeekdaysState();
        });

        callbacksSettings.context.on("click", ".v-clearAllDisabledDates", function () {
            callbacksSettings.disabledDatesCalendar.multiDatesPicker("resetDates");
            callbacksSettings.disabledDatesCalendar.datepicker("refresh");
            callbacksSettings.updateDisabledDates([]);
            callbacksSettings.selectedDisabledDates = [];
        });

        callbacksSettings.context.on("click", ".v-removeDisabledDate", function () {
            var disabledDates = _.difference(callbacksSettings.disabledDatesCalendar.multiDatesPicker("getDates"), callbacksSettings.selectedDisabledDates)

            callbacksSettings.disabledDatesCalendar.multiDatesPicker("resetDates");

            if (disabledDates.length > 0) {
                callbacksSettings.disabledDatesCalendar.multiDatesPicker("addDates", disabledDates);
            }

            callbacksSettings.updateDisabledDates(disabledDates);
            callbacksSettings.disabledDatesCalendar.datepicker("refresh");
            callbacksSettings.selectedDisabledDates = [];
        });

        callbacksSettings.context.on("click", ".h-disabledDatesList div", function () {
            var date = $(this).attr("data-value");

            if (_.indexOf(callbacksSettings.selectedDisabledDates, date) > -1) {
                callbacksSettings.selectedDisabledDates.splice(date, 1);
                $(this).removeClass("selected");
            }
            else {
                callbacksSettings.selectedDisabledDates.push(date);
                $(this).addClass("selected");
            }
        });
    },
    updateCalendarWeekdaysState: function () {
        callbacksSettings.unavailableWeekdays = $(".v-calendar-days input:checkbox:not(:checked)").map(function () {
            return $(this).attr("data-index");
        }).get();

        callbacksSettings.disabledDatesCalendar.datepicker("option", "beforeShowDay", callbacksSettings.getCalendarWeekdaysState);
    },
    getCalendarWeekdaysState: function (date) {
        var result = callbacksSettings.disabledDatesCalendar.multiDatesPicker("getBeforeShowDayState", date);

        for (var i = 0; i < callbacksSettings.unavailableWeekdays.length; i++) {
            if (callbacksSettings.unavailableWeekdays[i] == date.getDay()) {
                result[0] = false;
            }
        }

        return result;
    },
    updateDisabledDates: function (dates) {
        $(".h-disabledDatesList", callbacksSettings.context).empty();

        _.each(dates, function (date) {
            var selected = "";

            if (_.indexOf(callbacksSettings.selectedDisabledDates, date) > -1) {
                selected = "selected";
            }

            $(".h-disabledDatesList", callbacksSettings.context).append($("<div />", { "class": "disabled-date " + selected, "data-value": date }).append(date));
        });

        $("#Calendar_DisabledDatesJSON", callbacksSettings.context).val(dates.join(",")).trigger("change");
    }
}

$(document).ready(function () {
    if (callbacksSettings.context.length > 0) {
        callbacksSettings.initialize();
        callbacksSettings.bindEvents();
    }
});